#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


library(limma)              #library package
expFile="GeneExp.txt"     #expression data file
diffFile="C2-C1.diff.txt"         #file of differential genes
setwd("E:\\metabolism\\LGG\\16.ANN_validation\\Rembrandt\\2.geneScore")      

#Read expression files and tidy up input files
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)

#Read files of differential genes
diffRT=read.table(diffFile, header=T, sep="\t", check.names=F, row.names=1)
diffRT=diffRT[row.names(data),]

#gene score
dataUp=data[diffRT[,"logFC"]>0,]
dataDown=data[diffRT[,"logFC"]<0,]
dataUp2=t(apply(dataUp,1,function(x)ifelse(x>median(x),1,0)))
dataDown2=t(apply(dataDown,1,function(x)ifelse(x>median(x),0,1)))

#Output the results of the gene score
outTab=rbind(dataDown2,dataUp2)
outTab=rbind(id=colnames(outTab), outTab)
write.table(outTab, file="geneScore.txt", sep="\t", quote=F, col.names=F)


